<?php
/**
 * Class TravelPhysVariation
 * @version 1.0.0
 * @author  physcode
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TravelPhysVariation {

	public static function init() {

	}

	public static function view_variation_detail( $tour_variations, $tour_variations_options ) {
		$class_item = 'variation-item-details';

		do_action( 'before_show_variation_details', $tour_variations, $tour_variations_options );

		$html_variation_view = '<div class="variation-details">';

		foreach ( $tour_variations as $key => $tour_variant ) {
			$tour_variant_item = $tour_variations_options->$key;
			$label_variation   = $tour_variant_item->label_variation;

			foreach ( $tour_variant as $k_attr => $tour_variant_attr ) {
				$label_attr = $tour_variant_item->variation_attr->{$k_attr}->label;

				if ( $tour_variant_item->type_variation === 'quantity' ) {
					if ( $tour_variant_item->set_price == 1 ) {
						$price_attr          = $tour_variant_item->variation_attr->{$k_attr}->price;
						$qty_attr            = $tour_variant_attr->quantity;
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '&nbsp;(' . TravelPhysUtility::tour_format_price($price_attr) . ')&nbsp;&times;' . $qty_attr . '</div>';
					}
				} elseif ( $tour_variant_item->type_variation === 'select' ) {
					if ( $tour_variant_item->set_price == 1 ) {
						$price_attr          = $tour_variant_item->variation_attr->{$k_attr}->price;
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '&nbsp;(' . TravelPhysUtility::tour_format_price($price_attr) . ')</div>';
					} else {
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '</div>';
					}
				} elseif ( $tour_variant_item->type_variation === 'checkbox' ) {
					if ( $tour_variant_item->set_price == 1 ) {
						$price_attr          = $tour_variant_item->variation_attr->{$k_attr}->price;
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '&nbsp;(' . TravelPhysUtility::tour_format_price($price_attr) . ')</div>';
					} else {
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '</div>';
					}
				} elseif ( $tour_variant_item->type_variation === 'radio' ) {
					if ( $tour_variant_item->set_price == 1 ) {
						$price_attr          = $tour_variant_item->variation_attr->{$k_attr}->price;
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '&nbsp;(' . TravelPhysUtility::tour_format_price($price_attr) . ')</div>';
					} else {
						$html_variation_view .= '<div class="' . $class_item . '"><strong>' . __( $label_variation, 'travel-booking' ) . '</strong>:&nbsp;' . $label_attr . '</div>';
					}
				}
			}
		}
		$html_variation_view .= '</div>';

		do_action( 'after_show_variation_details', $tour_variations, $tour_variations_options );

		return $html_variation_view;
	}
}

TravelPhysVariation::init();
